/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReinforcedDoor
extends BlockDoor
implements ITileEntityProvider {
    public BlockReinforcedDoor(Material material) {
        super(material);
        this.field_149758_A = true;
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            boolean isNotPowered;
            boolean bl = isNotPowered = this.hasNoActiveSCBlocksNear(world, pos) && this.hasNoActiveSCBlocksNear(world, pos.func_177977_b());
            if (isNotPowered) {
                this.closeDoor(world, pos.func_177977_b());
                return;
            }
            BlockPos neighborPos = this.getNeighboringActiveSCBlock(world, pos.func_177977_b(), neighborBlock);
            if (neighborPos != null) {
                this.onNeighborChange((IBlockAccess)world, pos.func_177977_b(), neighborPos);
            } else {
                neighborPos = this.getNeighboringActiveSCBlock(world, pos, neighborBlock);
                if (neighborPos != null) {
                    this.onNeighborChange((IBlockAccess)world, pos, neighborPos);
                }
            }
        } else {
            boolean isNotPowered;
            boolean bl = isNotPowered = this.hasNoActiveSCBlocksNear(world, pos) && this.hasNoActiveSCBlocksNear(world, pos.func_177984_a());
            if (isNotPowered) {
                this.closeDoor(world, pos);
                return;
            }
            BlockPos neighborPos = this.getNeighboringActiveSCBlock(world, pos, neighborBlock);
            if (neighborPos != null) {
                this.onNeighborChange((IBlockAccess)world, pos, neighborPos);
            } else {
                neighborPos = this.getNeighboringActiveSCBlock(world, pos.func_177984_a(), neighborBlock);
                if (neighborPos != null) {
                    this.onNeighborChange((IBlockAccess)world, pos.func_177984_a(), neighborPos);
                }
            }
        }
    }

    private void closeDoor(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)field_176519_b)).booleanValue()) {
            return;
        }
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            pos = pos.func_177977_b();
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(false)), 2);
        world.func_175704_b(pos, pos);
        this.checkAndChangeDoubleDoors(world, pos, state, false);
        world.func_180498_a((EntityPlayer)null, 1011, pos, 0);
    }

    public void onNeighborChange(IBlockAccess access, BlockPos pos, BlockPos neighbor) {
        World world = (World)access;
        IBlockState state = world.func_180495_p(pos);
        Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockBelow = pos.func_177977_b();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.onNeighborChange((IBlockAccess)world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = pos.func_177984_a();
            IBlockState stateAbove = world.func_180495_p(blockAbove);
            if (stateAbove.func_177230_c() != this) {
                world.func_175698_g(pos);
                drop = true;
            }
            if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                world.func_175698_g(pos);
                drop = true;
                if (stateAbove.func_177230_c() == this) {
                    world.func_175698_g(blockAbove);
                }
            }
            if (drop) {
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
            } else {
                boolean hasActiveSCBlock;
                boolean bl = hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(world, pos) || BlockUtils.hasActiveSCBlockNextTo(world, pos.func_177984_a());
                if ((hasActiveSCBlock || neighborBlock.func_149744_f(stateAbove)) && neighborBlock != this && hasActiveSCBlock != (Boolean)stateAbove.func_177229_b((IProperty)field_176522_N) && hasActiveSCBlock != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(hasActiveSCBlock)).func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                    world.func_175704_b(pos, pos);
                    this.checkAndChangeDoubleDoors(world, pos, state, hasActiveSCBlock);
                    world.func_180498_a((EntityPlayer)null, hasActiveSCBlock ? 1005 : 1011, pos, 0);
                }
            }
        }
    }

    public void checkAndChangeDoubleDoors(World world, BlockPos pos, IBlockState state, boolean open) {
        if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.WEST) {
            IBlockState secondDoorState = world.func_180495_p(pos.func_177978_c());
            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                world.func_180501_a(pos.func_177978_c(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                world.func_175704_b(pos.func_177978_c(), pos.func_177978_c());
            } else {
                secondDoorState = world.func_180495_p(pos.func_177968_d());
                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                    world.func_180501_a(pos.func_177968_d(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                    world.func_175704_b(pos.func_177968_d(), pos.func_177968_d());
                }
            }
        } else if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.NORTH) {
            IBlockState secondDoorState = world.func_180495_p(pos.func_177974_f());
            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                world.func_180501_a(pos.func_177974_f(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                world.func_175704_b(pos.func_177974_f(), pos.func_177974_f());
            } else {
                secondDoorState = world.func_180495_p(pos.func_177976_e());
                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                    world.func_180501_a(pos.func_177976_e(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                    world.func_175704_b(pos.func_177976_e(), pos.func_177976_e());
                }
            }
        } else if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.EAST) {
            IBlockState secondDoorState = world.func_180495_p(pos.func_177968_d());
            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                world.func_180501_a(pos.func_177968_d(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                world.func_175704_b(pos.func_177968_d(), pos.func_177968_d());
            } else {
                secondDoorState = world.func_180495_p(pos.func_177978_c());
                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                    world.func_180501_a(pos.func_177978_c(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                    world.func_175704_b(pos.func_177978_c(), pos.func_177978_c());
                }
            }
        } else if (state.func_177229_b((IProperty)field_176520_a) == EnumFacing.SOUTH) {
            IBlockState secondDoorState = world.func_180495_p(pos.func_177976_e());
            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                world.func_180501_a(pos.func_177976_e(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                world.func_175704_b(pos.func_177976_e(), pos.func_177976_e());
            } else {
                secondDoorState = world.func_180495_p(pos.func_177974_f());
                if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)field_176519_b) != open) {
                    world.func_180501_a(pos.func_177974_f(), secondDoorState.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 2);
                    world.func_175704_b(pos.func_177974_f(), pos.func_177974_f());
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    private BlockPos getNeighboringActiveSCBlock(World world, BlockPos pos, Block neighbor) {
        if (neighbor instanceof BlockLaserBlock && BlockUtils.hasActiveLaserNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
            if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177984_a();
            }
            if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177977_b();
            }
        } else if (neighbor instanceof BlockRetinalScanner && BlockUtils.hasActiveScannerNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockRetinalScanner.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockRetinalScanner.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockRetinalScanner.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockRetinalScanner.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
            if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockRetinalScanner.POWERED)).booleanValue()) {
                return pos.func_177984_a();
            }
            if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockRetinalScanner.POWERED)).booleanValue()) {
                return pos.func_177977_b();
            }
        } else if (neighbor instanceof BlockKeypad && BlockUtils.hasActiveKeypadNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockKeypad.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockKeypad.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockKeypad.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockKeypad.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
            if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockKeypad.POWERED)).booleanValue()) {
                return pos.func_177984_a();
            }
            if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockKeypad.POWERED)).booleanValue()) {
                return pos.func_177977_b();
            }
        } else if (neighbor instanceof BlockKeycardReader && BlockUtils.hasActiveReaderNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockKeycardReader.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockKeycardReader.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockKeycardReader.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockKeycardReader.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
            if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockKeycardReader.POWERED)).booleanValue()) {
                return pos.func_177984_a();
            }
            if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockKeycardReader.POWERED)).booleanValue()) {
                return pos.func_177977_b();
            }
        } else if (neighbor instanceof BlockInventoryScanner && BlockUtils.hasActiveInventoryScannerNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177974_f())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177974_f())).shouldProvidePower()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177976_e())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177976_e())).shouldProvidePower()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177968_d())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177968_d())).shouldProvidePower()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177978_c())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177978_c())).shouldProvidePower()) {
                return pos.func_177978_c();
            }
            if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177984_a())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177984_a())).shouldProvidePower()) {
                return pos.func_177984_a();
            }
            if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177977_b())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177977_b())).shouldProvidePower()) {
                return pos.func_177977_b();
            }
        }
        return null;
    }

    private boolean hasNoActiveSCBlocksNear(World world, BlockPos pos) {
        return !BlockUtils.hasActiveSCBlockNextTo(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(SCContent.reinforcedDoorItem);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : SCContent.reinforcedDoorItem;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable();
    }
}

